package ch.frankel.blog.sitemesh;

import static ch.frankel.blog.sitemesh.SiteMeshBugfixFilter.FILTER_APPLIED;
import static org.junit.Assert.assertNull;

import java.io.IOException;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import org.junit.Before;
import org.junit.Test;

import com.mockrunner.mock.web.MockFilterChain;
import com.mockrunner.mock.web.MockHttpServletRequest;
import com.mockrunner.mock.web.MockHttpServletResponse;

/**
 * Test class for class {@link SiteMeshBugfixFilter}.
 * 
 * @author Nicolas Frankel
 */
public class SiteMeshBugfixFilterTest {

	/** Filter to test. */
	private SiteMeshBugfixFilter filter;

	@Before
	public void setUp() throws Exception {

		filter = new SiteMeshBugfixFilter();
	}

	/**
	 * Test the
	 * {@link SiteMeshBugfixFilter#doFilter(ServletRequest, ServletResponse, FilterChain)}
	 * method.
	 * 
	 * @throws IOException
	 * @throws ServletException
	 */
	@Test
	public void testDoFilter() throws IOException, ServletException {

		ServletRequest request = new MockHttpServletRequest();
		ServletResponse response = new MockHttpServletResponse();
		FilterChain chain = new MockFilterChain();

		request.setAttribute(FILTER_APPLIED, "toto");

		filter.doFilter(request, response, chain);

		Object attr = request.getAttribute(FILTER_APPLIED);

		assertNull(attr);
	}
}
